<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Requests\Hashtag\HashtagContent;
use Erlage\Photogram\Requests\Hashtag\Post\HashtagPostContent;
use Erlage\Photogram\Requests\Hashtag\Follow\HashtagFollowActions;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | hashtag requests
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_HASHTAG_LOAD_SINGLE: HashtagContent::loadSingle();

    break;

    /*
    |--------------------------------------------------------------------------
    | hashtag follow requests
    |--------------------------------------------------------------------------
    */

    case RequestConstants::REQ_TYPE_HASHTAG_FOLLOW_ADD: HashtagFollowActions::add();

    break;

    case RequestConstants::REQ_TYPE_HASHTAG_FOLLOW_REMOVE: HashtagFollowActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | hashtag post requests
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_HASHTAG_POST_HASHTAG_FEED_LOAD_LATEST:
        HashtagPostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_HASHTAG_POST_HASHTAG_FEED_LOAD_BOTTOM:
        HashtagPostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    case RequestConstants::REQ_TYPE_HASHTAG_POST_GLOBAL_FEED_LOAD_LATEST:
        HashtagPostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_HASHTAG_POST_GLOBAL_FEED_LOAD_BOTTOM:
        HashtagPostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;
}
